#!/bin/sh
#
# Generate several different layouted letters
#

options[0]="dante"
options[1]="DINmtext,dante"
options[2]="SN,dante"
options[3]="email,koma"
options[4]="DIV=9,danteTypA"
options[5]="DIV=9,danteTypB"
options[6]="DIV=9,danteTypC"
options[7]="koma,fromalign=left,fromlogo"
options[8]="koma,fromalign=right,fromlogo"
options[9]="koma,fromalign=center,fromrule=aftername"

n=0
while [ $n -lt ${#options[@]} ]; do
    cat >brief${n}.tex <<EOF
% Demo-Brief $n
\documentclass[${options[$n]}]{scrlttr2}
\input{brief.tex}
\endinput
EOF
    echo $brief${n}.tex:
    if pdflatex -interaction=batchmode brief${n}.tex; then
	rm brief${n}.aux brief${n}.log
    else
	echo "FEHLER!" >&2
	exit 1
    fi
    n=$((n+1))
done

echo briefdemo.tex:
if ! pdflatex -interaction=batchmode briefdemo.tex || \
    ! pdflatex -interaction=batchmode briefdemo.tex; then
    echo "FEHLER!" >&2
    exit 1
fi
